@extends('admin.layout.page-app')
@section('page_title', __('label.battles_questions'))
@section('tab_title', __('label.battles_questions'))

@section('content')
    @include('admin.layout.sidebar')

    <div class="right-content">
        @include('admin.layout.header')

        <div class="body-content">
            <!-- mobile title -->
            <h1 class="page-title-sm">{{__('label.battles_questions')}}</h1>

            <div class="border-bottom row mb-3">
                <div class="col-sm-9">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{__('label.dashboard')}}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{__('label.battles_questions')}}</li>
                    </ol>
                </div>
                <div class="col-sm-3 d-flex align-items-center justify-content-between">
                    <a href="{{ route('admin.battlesquestion.import.index') }}" class="btn btn-default mw-120" style="margin-top: -14px;">{{__('label.import_question')}}</a>
                    <a href="{{ route('admin.battlesquestion.create') }}" class="btn btn-default mw-120" style="margin-top: -14px;">{{__('label.add_question')}}</a>
                </div>
            </div>

            <!-- Search & Table -->
            <div class="card custom-border-card">
                <div class="page-search mb-3">
                    <div class="input-group">
                        <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1"><i class="fa-solid fa-magnifying-glass fa-xl"></i></span>
                        </div>
                        <input type="text" id="input_search" class="form-control" placeholder="{{__('label.search')}}" aria-label="Search" aria-describedby="basic-addon1">
                    </div>
                </div>

                <div class="table-responsive">
                    <table class="table table-striped text-center table-bordered" id="datatable">
                        <thead>
                            <tr>
                                <th>{{__('label.#')}}</th>
                                <th>{{__('label.image')}}</th>
                                <th>{{__('label.question')}}</th>
                                <th>{{__('label.option_a')}}</th>
                                <th>{{__('label.option_b')}}</th>
                                <th>{{__('label.option_c')}}</th>
                                <th>{{__('label.option_d')}}</th>                                
                                <th>{{__('label.status')}}</th>
                                <th>{{__('label.action')}}</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('pagescript')
    <script>
        $(document).ready(function() {
            var table = $('#datatable').DataTable({
                ...dataTableDefaults,
                ajax:
                    {
                    url: "{{ route('admin.battlesquestion.index') }}",
                    data: function(d){
                        d.input_search = $('#input_search').val();
                    },
                },
                columns: [
                    { data: 'DT_RowIndex', name: 'DT_RowIndex', orderable: false, searchable: false },
                    {
                        data: 'image',
                        name: 'image',
                        orderable: false,
                        searchable: false,
                        render: function(data, type, full, meta) {
                            return "<a href='" + data + "' target='_blank'><img src='" + data + "' class='img-thumbnail' style='height:60px; width:60px'></a>";
                        },
                    },
                    {
                        data: 'question',
                        name: 'question',
                        width: '25%',
                        render: function(data) {
                            return data ? '<div style="text-align: left; font-size: 14px;">' + data + '</div>' : "-";
                        }
                    },
                    {
                        data: 'option_a',
                        name: 'option_a',
                        width: '10%',
                        orderable: false,
                        searchable: false,
                        render: function(data, type, row) {
                            const correct = parseInt(row.correct_answer);
                            const isCorrect = correct === 1 ? 'class="green-color font-weight-bold"' : '';
                            return `<div style="text-align: left;" ${isCorrect}>${row.option_a || '-'}</div>`;
                        }
                    },
                    {
                        data: 'option_b',
                        name: 'option_b',
                        width: '10%',
                        orderable: false,
                        searchable: false,
                        render: function(data, type, row) {
                            const correct = parseInt(row.correct_answer);
                            const isCorrect = correct === 2 ? 'class="green-color font-weight-bold"' : '';
                            return `<div style="text-align: left;" ${isCorrect}>${row.option_b || '-'}</div>`;
                        }
                    },
                    {
                        data: 'option_c',
                        name: 'option_c',
                        width: '10%',
                        orderable: false,
                        searchable: false,
                        render: function(data, type, row) {
                            const correct = parseInt(row.correct_answer);
                            const isCorrect = correct === 3 ? 'class="green-color font-weight-bold"' : '';
                            return `<div style="text-align: left;" ${isCorrect}>${row.option_c || '-'}</div>`;
                        }
                    },
                    {
                        data: 'option_d',
                        name: 'option_d',
                        width: '10%',
                        orderable: false,
                        searchable: false,
                        render: function(data, type, row) {
                            const correct = parseInt(row.correct_answer);
                            const isCorrect = correct === 4 ? 'class="green-color font-weight-bold"' : '';
                            return `<div style="text-align: left;" ${isCorrect}>${row.option_d || '-'}</div>`;
                        }
                    },
                    {
                        data: 'status',
                        name: 'status',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                ]
            });

            $('#input_search').keyup(function(){
                table.draw();
            });
        });

        function change_status(id) {

            var Demo_Mode = '<?php echo Demo_Mode(); ?>';
            if(Demo_Mode == 1){

                $("#dvloader").show();
                var url = `{{ route('admin.battlesquestion.show', '') }}/${id}`;

                $.ajax({
                    type: "GET",
                    url: url,
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(resp) {
                        $("#dvloader").hide();

                        if (resp.status == 200) {
                            if (resp.status_code == 1) {
                                $('#' + id).text('{{__("label.show")}}').removeClass('hide-btn').addClass('show-btn');
                            } else {
                                $('#' + id).text('{{__("label.hide")}}').removeClass('show-btn').addClass('hide-btn');
                            }
                            toastr.success(resp.success);
                        } else {
                            toastr.error(resp.errors);
                        }
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
                });
            } else {
                showError();
            }
        };
    </script>
@endsection